<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\OrganizationController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\OrganizationInvitationController;
use Illuminate\Foundation\Application;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

Route::get('/', function () {
    return Inertia::render('Welcome', [
        'canLogin' => Route::has('login'),
        'canRegister' => Route::has('register'),
        'laravelVersion' => Application::VERSION,
        'phpVersion' => PHP_VERSION,
    ]);
});

Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // Organizations - Constants route must come before resource route
    Route::get('/organizations/constants', [OrganizationController::class, 'constants'])
        ->name('organizations.constants');
        
    Route::resource('organizations', OrganizationController::class);
    
    // Member management routes
    Route::post('organizations/{organization}/members/{user}/remove', [OrganizationController::class, 'removeMember'])
        ->name('organizations.members.remove');
    Route::patch('organizations/{organization}/members/{user}/role', [OrganizationController::class, 'updateMemberRole'])
        ->name('organizations.members.updateRole');

    // Profile routes
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Organization Invitations
    Route::get('organizations/{organization}/invitations', [OrganizationInvitationController::class, 'index'])
        ->name('organizations.invitations.index');
    Route::post('organizations/{organization}/invitations', [OrganizationInvitationController::class, 'store'])
        ->name('organizations.invitations.store');
    Route::post('organizations/{organization}/invitations/{invitation}/resend', [OrganizationInvitationController::class, 'resend'])
        ->name('organizations.invitations.resend');
    Route::delete('organizations/{organization}/invitations/{invitation}', [OrganizationInvitationController::class, 'destroy'])
        ->name('organizations.invitations.destroy');
    
    // Public invitation routes (for accepting/declining)
    Route::get('invitations/{token}/accept', [OrganizationInvitationController::class, 'accept'])
        ->name('invitations.accept');
    Route::get('invitations/{token}/decline', [OrganizationInvitationController::class, 'decline'])
        ->name('invitations.decline');
});

require __DIR__.'/auth.php';
