<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OrganizationInvitation extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'organization_id',
        'invited_by',
        'email',
        'role',
        'token',
        'expires_at',
        'accepted_at',
        'declined_at',
    ];

    protected $casts = [
        'expires_at' => 'datetime',
        'accepted_at' => 'datetime',
        'declined_at' => 'datetime',
    ];

    public function organization()
    {
        return $this->belongsTo(Organization::class);
    }

    public function inviter()
    {
        return $this->belongsTo(User::class, 'invited_by');
    }

    public function isExpired()
    {
        return $this->expires_at->isPast();
    }

    public function isPending()
    {
        return !$this->accepted_at && !$this->declined_at && !$this->isExpired();
    }

    public function isAccepted()
    {
        return !is_null($this->accepted_at);
    }

    public function isDeclined()
    {
        return !is_null($this->declined_at);
    }

    public function getStatus()
    {
        if ($this->isAccepted()) return 'accepted';
        if ($this->isDeclined()) return 'declined';
        if ($this->isExpired()) return 'expired';
        return 'pending';
    }
} 