<?php

namespace App\Mail;

use App\Models\OrganizationInvitation;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Carbon;

class OrganizationInvitationMail extends Mailable
{
    use Queueable, SerializesModels;

    public $invitation;
    public $expiresAt;

    public function __construct(OrganizationInvitation $invitation)
    {
        $this->invitation = $invitation;
        $this->expiresAt = Carbon::parse($invitation->expires_at)->format('F j, Y \a\t g:i A');
    }

    public function build()
    {
        return $this->markdown('emails.organization-invitation')
            ->subject("Invitation to join {$this->invitation->organization->name}");
    }
} 