<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;
use App\Models\Organization;
use App\Models\User;

class OrganizationRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $rules = [
            'name' => ['required', 'string', 'max:255'],
            'description' => ['nullable', 'string', 'max:1000'],
            'organization_type' => ['required', 'string', Rule::in(array_keys(Organization::ORGANIZATION_TYPES))],
            'industries' => ['required', 'array', 'min:1'],
            'industries.*' => ['string', Rule::in(array_keys(Organization::INDUSTRIES))],
            'employee_count_range' => ['required', 'string', Rule::in(array_keys(Organization::EMPLOYEE_RANGES))],
            'region' => ['required', 'string'],
            'timezone' => ['required', 'string'],
            'primary_aws_region' => ['required', 'string'],
            'compliance_requirements' => ['nullable', 'array'],
            'compliance_requirements.*' => ['string', Rule::in(array_keys(Organization::COMPLIANCE_STANDARDS))],
            'aws_org_role' => ['required', 'string', Rule::in(array_keys(Organization::AWS_ORG_ROLES))],
            'tags' => ['nullable', 'array'],
            'tags.*' => ['string'],
            'onboarding_goal' => ['required', 'string', Rule::in(array_keys(Organization::ONBOARDING_GOALS))],
        ];
        $user = auth()->user();
        // Only require phone_number for create
       
       if($user->phone_number == null){
            if ($this->isMethod('post')) {
                $rules['phone_number'] = [
                    'required', 
                    'string', 
                    'regex:/^([0-9\s\-\+\(\)]*)$/',
                    'min:10',
                ];
        }
        }

        return $rules;
    }

    public function messages(): array
    {
        return [
            'name.required' => 'The organization name is required.',
            'name.max' => 'The organization name cannot be longer than 255 characters.',
            'organization_type.required' => 'Please select an organization type.',
            'industries.required' => 'Please select at least one industry.',
            'industries.min' => 'Please select at least one industry.',
            'employee_count_range.required' => 'Please select the number of employees.',
            'region.required' => 'Please select your region.',
            'timezone.required' => 'Please select your timezone.',
            'primary_aws_region.required' => 'Please select your primary AWS region.',
            'aws_org_role.required' => 'Please specify your AWS Organization role.',
            'onboarding_goal.required' => 'Please select your main goal.',
            'phone_number.required' => 'A phone number is required for emergency contact.',
            'phone_number.regex' => 'Please enter a valid phone number.',
            'phone_number.min' => 'Phone number must be at least 10 characters.',
        ];
    }

    public function attributes(): array
    {
        return [
            'name' => 'organization name',
        ];
    }
} 